#include "ScnPickPath.h"
#include "freestyledash.h"
#include "loadingthread.h"
#include <direct.h>
#include <string>
#include "Contentlist.h"
using namespace std;

HRESULT CScnPickPath::OnInit( XUIMessageInit* pInitData, BOOL& bHandled )
{
	DebugMsg("Display PickPath");

	GetChildById( L"BtnUsb", &btnUSB );
    GetChildById( L"BtnHDD", &bntHDD );
	return S_OK;
}

HRESULT CScnPickPath::OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled )
{
	if (cl.Loaded)
		return S_OK;

	if (hObjPressed == btnUSB)
	{
		datapath = L"usb0:\\fsdata\\";
	} else if (hObjPressed == bntHDD)
	{
		datapath = L"hdd1:\\fsdata\\";
	}

	if (!datapath.empty())
	{
		if (!FileExists(datapath))
			_wmkdir(datapath.c_str());

		wstring data;
		wstring dest = datapath + L"config.xml";
		int res = CopyFile("game:\\base\\config.xml",wstrtostr(dest).c_str(),false);
		DebugMsg("CopyFile returned %d",res);
		//FileToString(data,L"game:\\base\\config.xml");
		//DebugMsg("%S",data.c_str());
		//StringToFile(data,datapath + L"config.xml");

		//Sleep(1000);

		RestartFreestyle();
	}

    bHandled = TRUE;
    return S_OK;
}